using System;
using System.Collections;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a lady jennifyr corpse" )]
	public class LadyJennifyr : BaseCreature
	{
		[Constructable]
		public LadyJennifyr() : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.015, 0.075 )
		{
			Name = "a lady jennifyr";
			Hue = 0x76D;
			Body = 0x93;
			BaseSoundID = 0x1C3;

			SetStr( 208, 309 );
			SetDex( 91, 118 );
			SetInt( 44, 101 );

			SetHits( 1113, 1285 );

			SetDamage( 15, 25 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Cold, 60 );

			SetResistance( ResistanceType.Physical, 56, 65 );
			SetResistance( ResistanceType.Fire, 41, 49 );
			SetResistance( ResistanceType.Cold, 71, 80 );
			SetResistance( ResistanceType.Poison, 41, 50 );
			SetResistance( ResistanceType.Energy, 50, 58 );

			SetSkill( SkillName.EvalInt, 120.1, 130.0 );
			SetSkill( SkillName.SpiritSpeak, 120.0 );
			SetSkill( SkillName.Necromancy, 120.0 );
			SetSkill( SkillName.MagicResist, 100.0, 100.0 );
			SetSkill( SkillName.Tactics, 100.0, 100.0 );
			SetSkill( SkillName.Wrestling, 105.1, 105.0 );

			Fame = 15000;
			Karma = -15000;

			VirtualArmor = 40;
			
			AddItem( new PlateLegs() );
			PackItem( Loot.RandomNecromancerScroll() );
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosUltraRich );
		}

		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp

		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );
			
			if ( m_Table == null )
				m_Table = new Hashtable();
		
			if ( Combatant != null && m_Table[ Combatant ] == null )
			{
				ResistanceMod mod = new ResistanceMod( ResistanceType.Fire, -10 );
				Combatant.AddResistanceMod( mod );
				m_Table[ Combatant ] = mod;
				Timer.DelayCall( TimeSpan.FromSeconds( 30 ), new TimerStateCallback( EndMod_Callback ), Combatant );
			}
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );		
			
			if ( Utility.RandomDouble() < 0.30 )
			{
				Item item = new Klic();
				item.ItemID = 8826;
				item.Name = "Disintegrating Thesis Notes";
            c.DropItem( item );
         }
							
// 			if ( Utility.RandomDouble() < 0.1 )
// 				c.DropItem( new ParrotItem() );
		}
		
		
	
		public LadyJennifyr( Serial serial ) : base( serial )
		{
		}
		
		private static Hashtable m_Table;
		
		private void EndMod_Callback( object state )
		{
			if ( state is Mobile )
				RemoveResistanceMod( (Mobile) state );
		}
		
		public virtual void RemoveResistanceMod( Mobile from )
		{			
			if ( m_Table == null )
				m_Table = new Hashtable();
				
			if ( m_Table[ from ] != null )
			{
				from.RemoveResistanceMod( (ResistanceMod) m_Table[ from ] );
				m_Table[ from ] = null;
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}

